/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SPCPluginManager {
    public Vector plugins;
    public Vector disabledplugins;
    public HashMap commands;
    public PlayerHelper ph;
    public boolean enabled;
    public static SPCPluginManager MANAGER;

    public SPCPluginManager(PlayerHelper ph) {
        this.ph = ph;
        this.plugins = new Vector();
        this.disabledplugins = new Vector();
        this.commands = new HashMap();
        this.enabled = true;
        MANAGER = this;
    }

    public static SPCPluginManager getPluginManager() {
        return MANAGER;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean loadPlugins() {
        String failed = "";
        try {
            String test = PlayerHelper.class.getResource("PlayerHelper.class").toString();
            if (test.toLowerCase().startsWith("jar")) {
                String jarfile = test.replaceAll("jar:", "").split("!")[0];
                JarFile jf = new JarFile(new File(new URL(jarfile).toURI()));
                Enumeration<JarEntry> em = jf.entries();
                while (em.hasMoreElements()) {
                    JarEntry je = em.nextElement();
                    try {
                        if (!je.getName().toLowerCase().contains("spc_")) continue;
                        Package p = PlayerHelper.class.getPackage();
                        SPCPlugin plugin = SPCPluginManager.loadPlugin(je.getName(), p == null ? null : p.getName());
                        if (plugin != null) {
                            this.plugins.add(plugin);
                            Map cmds = SPCPluginManager.loadCommands(plugin);
                            if (cmds == null) continue;
                            this.commands.putAll(cmds);
                            continue;
                        }
                        failed = failed + je.getName() + " ";
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            } else {
                String classLocation = PlayerHelper.class.getName().replace('.', '/') + ".class";
                URLClassLoader loader = (URLClassLoader)PlayerHelper.class.getClassLoader();
                URL u = loader.getResource(classLocation);
                File[] f = new File(u.getFile()).getParentFile().listFiles();
                if (f == null) {
                    f = new File(u.toURI()).getParentFile().listFiles();
                }
                for (File temp : f) {
                    if (!temp.isFile() || !temp.getName().toLowerCase().startsWith("spc_")) continue;
                    try {
                        Package p = PlayerHelper.class.getPackage();
                        SPCPlugin plugin = SPCPluginManager.loadPlugin(temp.getName(), p == null ? null : p.getName());
                        if (plugin != null) {
                            this.plugins.add(plugin);
                            Map cmds = SPCPluginManager.loadCommands(plugin);
                            if (cmds == null) continue;
                            this.commands.putAll(cmds);
                            continue;
                        }
                        failed = failed + temp.getName() + " ";
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (!failed.equalsIgnoreCase("")) {
            this.ph.sendError("Plugin(s) failed to load: " + failed);
            this.ph.sendError("Please refer to installation instructions.");
        }
        return true;
    }

    public static SPCPlugin loadPlugin(String plugin, String pack) throws Exception {
        block7: {
            Class<?> c;
            if (!plugin.endsWith(".class")) {
                throw new Exception("Not a plugin.");
            }
            plugin = plugin.split("\\.")[0];
            plugin = pack == null ? plugin : pack + "." + plugin;
            plugin = plugin.replaceAll("/", ".");
            System.out.println("Attempting to load: " + plugin);
            URLClassLoader loader = (URLClassLoader)PlayerHelper.class.getClassLoader();
            try {
                c = loader.loadClass(plugin);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            if (c != null && SPCPlugin.class.isAssignableFrom(c)) {
                try {
                    SPCPlugin temp = (SPCPlugin)c.newInstance();
                    if (temp != null) {
                        return temp;
                    }
                    break block7;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            throw new Exception("Not a plugin.");
        }
        return null;
    }

    public static Map loadCommands(SPCPlugin plugin) {
        Method[] method = null;
        try {
            method = plugin.getClass().getDeclaredMethods();
        }
        catch (Exception e) {
            PlayerHelper.printStackTrace(e);
            return null;
        }
        HashMap<String, Object[]> temp = new HashMap<String, Object[]>();
        for (Method m : method) {
            try {
                m.setAccessible(true);
                Class<?>[] parameters = m.getParameterTypes();
                if (parameters.length == 0 || !parameters[0].isAssignableFrom(String[].class)) continue;
                SPCCommand info = null;
                info = m.getAnnotation(SPCCommand.class);
                if (info == null) continue;
                temp.put(info.cmd(), new Object[]{plugin, m, info});
            }
            catch (Exception e) {
                PlayerHelper.printStackTrace(e);
            }
        }
        return temp;
    }

    public boolean callPluginMethods(Method m, Object ... args) {
        if (m == null || args == null || !this.enabled) {
            return false;
        }
        boolean found = false;
        for (SPCPlugin p : this.plugins) {
            try {
                Object o = m.invoke((Object)p, args);
                if (!(o instanceof Boolean) || !((Boolean)o).booleanValue()) continue;
                found = true;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return found;
    }

    public boolean handleCommand(String[] args) {
        return this.handleCommand(args, this.commands);
    }

    public boolean handleCommand(String[] args, HashMap cmds) {
        if (args == null || cmds == null || args[0].equalsIgnoreCase("")) {
            return false;
        }
        Object[] value = (Object[])cmds.get(args[0]);
        if (value == null || value.length != 3) {
            return false;
        }
        try {
            Method command = (Method)value[1];
            SPCPlugin plugin = (SPCPlugin)value[0];
            command.invoke((Object)plugin, new Object[]{args});
        }
        catch (Exception e) {
            PlayerHelper.printStackTrace(e);
        }
        return true;
    }

    public String[] getCommands() {
        String[] help = new String[this.commands.size()];
        Iterator i2 = this.commands.keySet().iterator();
        for (int j = 0; j < help.length; ++j) {
            help[j] = (String)i2.next();
        }
        Vector<List> v = new Vector<List>();
        int count = 0;
        for (SPCPlugin plugin : this.plugins) {
            List temp = plugin.getCommands();
            if (temp == null) continue;
            count += temp.size();
            v.add(temp);
        }
        String[] allhelp = new String[count + help.length];
        int pointer = 0;
        for (String h : help) {
            allhelp[pointer++] = h;
        }
        Iterator it = v.iterator();
        while (it.hasNext()) {
            Iterator l = ((List)it.next()).iterator();
            while (l.hasNext()) {
                allhelp[pointer++] = (String)l.next();
            }
        }
        return allhelp;
    }

    public String[] getHelp(String command) {
        if (command == null || command.equalsIgnoreCase("")) {
            return null;
        }
        Object[] value = (Object[])this.commands.get(command);
        if (value == null) {
            for (SPCPlugin plugin : this.plugins) {
                String[] help = null;
                help = plugin.getHelp(command);
                if (help == null) continue;
                return help;
            }
            return null;
        }
        try {
            SPCCommand info = (SPCCommand)value[2];
            return new String[]{info.help(), info.args(), info.example()};
        }
        catch (Exception e) {
            PlayerHelper.printStackTrace(e);
            return null;
        }
    }

    public List getPlugins() {
        return this.plugins;
    }

    public List getDisabledPlugins() {
        return this.disabledplugins;
    }

    public boolean disablePlugin(SPCPlugin plugin) {
        if (this.plugins.remove(plugin)) {
            this.disabledplugins.add(plugin);
            return true;
        }
        return false;
    }

    public boolean enablePlugin(SPCPlugin plugin) {
        if (this.disabledplugins.remove(plugin)) {
            this.plugins.add(plugin);
            return true;
        }
        return false;
    }

    public SPCPlugin[] getPlugin(String name) {
        Vector<SPCPlugin> temp = new Vector<SPCPlugin>();
        for (SPCPlugin plugin : this.plugins) {
            if (plugin.getName() == null || !plugin.getName().equalsIgnoreCase(name)) continue;
            temp.add(plugin);
        }
        return temp.toArray(new SPCPlugin[temp.size()]);
    }

    static {
        try {
            File jar = new File(PlayerHelper.MODDIR, "jars");
            if (!jar.exists()) {
                jar.mkdir();
            } else {
                File[] bin = jar.listFiles();
                Vector<String> ignore = new Vector<String>();
                ignore.add("minecraft.jar");
                ignore.add("lwjgl.jar");
                ignore.add("lwjgl_util.jar");
                ignore.add("jinput.jar");
                for (File temp : bin) {
                    String name = temp.getName();
                    if (ignore.contains(name) || !name.endsWith(".jar")) continue;
                    PlayerHelper.addToClasspath(temp);
                }
            }
        }
        catch (Exception e) {
            PlayerHelper.printStackTrace(e);
        }
    }
}

