/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.installer;

import com.sijobe.installer.ManifestFile;
import com.sijobe.installer.ManifestScript;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ManifestHandler {
    public static final String[] ATTRIBUTE_NAMES = new String[]{"version", "datetime", "website", "readme", "terms", "banner", "description", "minecraftversion"};
    private File manifest;
    private Element base;
    private Map projects;
    private Map attributes;
    private Map files;

    public ManifestHandler(File manifest) {
        this.manifest = manifest;
        this.attributes = new HashMap();
        this.files = new HashMap();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document d = db.parse(this.manifest);
            this.base = d.getDocumentElement();
            if (this.base.getAttribute("version").compareTo("1.1") != 0) {
                throw new Exception("Manifest file is the wrong version for this reader. A different version of manifest detected");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map getProjects() {
        if (this.projects == null) {
            this.projects = new HashMap();
            NodeList nl = this.base.getElementsByTagName("project");
            if (nl != null) {
                int i = 0;
                while (i < nl.getLength()) {
                    Element e = (Element)nl.item(i);
                    if (e != null) {
                        this.projects.put(e.getAttribute("name"), e);
                    }
                    ++i;
                }
            }
        }
        return this.projects;
    }

    public String[] getProjectNames() {
        String[] names = new String[this.getProjects().size()];
        Iterator i = this.getProjects().keySet().iterator();
        int j = 0;
        while (i.hasNext()) {
            names[j++] = (String)i.next();
        }
        return names;
    }

    private Element getProject(String name) {
        return (Element)this.getProjects().get(name);
    }

    public Map getProjectAttributes(String project) {
        if (!this.attributes.containsKey(project)) {
            Element e = this.getProject(project);
            if (e == null) {
                return null;
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            int i = 0;
            while (i < ATTRIBUTE_NAMES.length) {
                NodeList n = e.getElementsByTagName(ATTRIBUTE_NAMES[i]);
                if (n != null && n.getLength() == 1) {
                    attributes.put(ATTRIBUTE_NAMES[i], ((Element)n.item(0)).getTextContent());
                } else {
                    attributes.put(ATTRIBUTE_NAMES[i], "");
                }
                ++i;
            }
            this.attributes.put(project, attributes);
        }
        return (Map)this.attributes.get(project);
    }

    public List getProjectManifest(String project) {
        if (!this.files.containsKey(project)) {
            ArrayList<Object> manifest = new ArrayList<Object>();
            Element e = this.getProject(project);
            if (e == null) {
                return null;
            }
            NodeList rawmanifest = e.getElementsByTagName("manifest");
            int i = 0;
            while (i < rawmanifest.getLength()) {
                NodeList files = ((Element)rawmanifest.item(i)).getElementsByTagName("file");
                int j = 0;
                while (j < files.getLength()) {
                    Element file = (Element)files.item(j);
                    if (file != null) {
                        String source = file.getAttribute("source");
                        String destination = file.getAttribute("destination");
                        String description = file.getAttribute("description");
                        boolean required = true;
                        try {
                            required = Boolean.parseBoolean(file.getAttribute("required"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        manifest.add(new ManifestFile(source, destination, description, required));
                    }
                    ++j;
                }
                NodeList scripts = ((Element)rawmanifest.item(i)).getElementsByTagName("script");
                int j2 = 0;
                while (j2 < scripts.getLength()) {
                    Element script = (Element)scripts.item(j2);
                    if (script != null) {
                        String source = script.getAttribute("source");
                        String type = script.getAttribute("type");
                        String classname = script.getAttribute("class");
                        String dependency = script.getAttribute("dependencies");
                        String[] dependencies = null;
                        if (dependency != null) {
                            dependencies = dependency.split(";");
                        }
                        manifest.add(new ManifestScript(source, type, classname, dependencies));
                    }
                    ++j2;
                }
                ++i;
            }
            this.files.put(project, manifest);
        }
        return (List)this.files.get(project);
    }

    public String getVersion(String project) {
        return (String)this.getProjectAttributes(project).get("version");
    }

    public String getDateTime(String project) {
        return (String)this.getProjectAttributes(project).get("datetime");
    }

    public String getWebsite(String project) {
        return (String)this.getProjectAttributes(project).get("website");
    }

    public String getReadme(String project) {
        return (String)this.getProjectAttributes(project).get("readme");
    }

    public String getTerms(String project) {
        return (String)this.getProjectAttributes(project).get("terms");
    }

    public String getBanner(String project) {
        return (String)this.getProjectAttributes(project).get("banner");
    }

    public String getDescription(String project) {
        return (String)this.getProjectAttributes(project).get("description");
    }

    public String getMinecraftVersion(String project) {
        return (String)this.getProjectAttributes(project).get("minecraftversion");
    }
}

