/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.installer.v1copy;

import com.sijobe.installer.v1copy.Util;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;

public class ThreadBackupWorlds
extends Thread {
    private File mcdir;
    private Method callback;

    public ThreadBackupWorlds(File mcdir) {
        this.mcdir = mcdir;
    }

    public void setCallback(Method callback) {
        this.callback = callback;
    }

    private void signalDone(String err) {
        if (this.callback != null) {
            try {
                this.callback.invoke(null, err);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void run() {
        if (this.mcdir == null || !this.mcdir.exists()) {
            this.signalDone("Couldn't discover Minecraft home directory.");
            return;
        }
        File saves = new File(this.mcdir, "saves");
        if (!saves.exists()) {
            this.signalDone("Couldn't find Minecraft.jar");
            return;
        }
        File destination = new File(this.mcdir, "backup/saves");
        try {
            destination.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!destination.exists()) {
            this.signalDone("Couldn't create destination directory for backup.");
            return;
        }
        List in = Util.getFiles(new File(this.mcdir, "saves"));
        int i = 0;
        while (i < in.size()) {
            File f = (File)in.get(i);
            if (f.isDirectory()) {
                File dir = new File(destination, f.getName());
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                Util.compressFiles(f, new File(dir, String.valueOf(f.getName()) + "." + System.currentTimeMillis() + ".zip"));
            } else {
                Util.compressFiles(f, new File(destination, String.valueOf(f.getName()) + "." + System.currentTimeMillis() + ".zip"));
            }
            ++i;
        }
        this.signalDone(null);
    }
}

