/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JLabel;

public class JHyperLink
extends JLabel
implements MouseListener {
    private static final long serialVersionUID = -380989924723873157L;
    private String label;
    private File file;
    private URI uri;
    private boolean isUrl;
    private Cursor previousCursor;

    public JHyperLink(String label, File file) {
        super(label);
        this.init(label, file, null);
        this.isUrl = false;
    }

    public JHyperLink(String label, URI uri) {
        super(label);
        this.init(label, null, uri);
        this.isUrl = true;
    }

    public JHyperLink(String label, String link) {
        super(label);
        if (link.startsWith("http://") || link.startsWith("https://")) {
            try {
                this.init(label, null, new URI(link));
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            this.init(label, new File(link), null);
        }
    }

    private void init(String label, File file, URI uri) {
        this.label = label;
        this.uri = uri;
        this.file = file;
        this.setForeground(new Color(0, 0, 255));
        this.setFont(new Font("Tahoma", 0, 9));
        this.addMouseListener(this);
        this.setUnderlined(true);
        this.previousCursor = this.getCursor();
    }

    private void setUnderlined(boolean underlined) {
        if (underlined) {
            this.setText("<html><body><u>" + this.label + "</u></body></html>");
        } else {
            this.setText(this.label);
        }
    }

    public void mouseEntered(MouseEvent arg) {
        this.setUnderlined(false);
        this.previousCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void mouseExited(MouseEvent arg) {
        this.setUnderlined(true);
        this.setCursor(this.previousCursor);
    }

    public void mouseClicked(MouseEvent arg) {
        if (Desktop.isDesktopSupported()) {
            Desktop d = Desktop.getDesktop();
            if (this.isUrl) {
                try {
                    d.browse(this.uri);
                }
                catch (IOException e) {
                    System.err.println("Cannot open provided url link.");
                }
            } else {
                try {
                    d.open(this.file);
                }
                catch (Exception exc) {
                    System.err.println("Cannot open provided file link.");
                }
            }
        }
    }

    public void mousePressed(MouseEvent arg) {
    }

    public void mouseReleased(MouseEvent arg) {
    }
}

